/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.action;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;


import jp.mosp.common.CommonConst;
import jp.mosp.common.MosPAction;
import jp.mosp.common.common.LogUtility;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dao.MosPUserDao;
import jp.mosp.common.dto.CmUserDto;

import jp.mosp.system.vo.AccountMasterListVo;

public class AccountMasterListAction extends MosPAction {

	// R}h
	private static final String CMD_ACCOUNT_MASTER_LIST_SHOW      = "S2400";
	private static final String CMD_ACCOUNT_MASTER_LIST_SEARCH    = "S2401";
	public  static final String CMD_ACCOUNT_MASTER_LIST_RE_SEARCH = "S2402";
	private static final String CMD_ACCOUNT_MASTER_LIST_SORT      = "S2403";
	private static final String CMD_ACCOUNT_MASTER_LIST_PASS_INIT = "S2404";

	/**
	 * RXgN^
	 */
	public AccountMasterListAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		// VO̎擾
		AccountMasterListVo vo;
		Object obj = session.getAttribute(MospConst.ATT_FORMER_VO);
		if (obj instanceof AccountMasterListVo) {
			vo = (AccountMasterListVo)obj;
		} else {
			vo = new AccountMasterListVo();
		}
		vo.clearMessage();
		vo.clearErrField();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		session.setAttribute(MospConst.ATT_FORMER_VO, vo);
		// [hݒ
		setMode(vo);
		// R}h̏
		if (cmd.equals(CMD_ACCOUNT_MASTER_LIST_SHOW)) {
			// \
			vo.setPltDelete(MospConst.DELETE_FLAG_OFF);
			/*						
			 *  	2009/01/09	k.taniai	j[AWΉ
			 */
			vo.aryPltAuthority = util.combineArray(getCodeArray(CommonConst.TID_AUTHORITY), getArrangeAuthArray());
		} else if (cmd.equals(CMD_ACCOUNT_MASTER_LIST_SEARCH)) {
			// 
			vo.setParams(request);
			searchUserList(vo);
			vo.setFormerKey(vo.KEY_USER_ID);
			vo.setIsAscending(true);
			vo.initListInfo();
		} else if (cmd.equals(CMD_ACCOUNT_MASTER_LIST_RE_SEARCH)) {
			// Č
			session.removeAttribute(MospConst.ATT_DTO);
			searchUserList(vo);
			vo.setPageButton();
			sortList(vo);
		} else if (cmd.equals(CMD_ACCOUNT_MASTER_LIST_SORT)) {
			// \[g
			sortList(key1, vo);
		} else if (cmd.equals(CMD_ACCOUNT_MASTER_LIST_PASS_INIT)) {
			// pX[h
			initPassword(vo, key1);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * [U[Xg
	 * @param vo UserListVoCX^X
	 * @throws Exception
	 */
	private void searchUserList(AccountMasterListVo vo) throws Exception {
		// DBRlNV̎擾
		getConnection();
		// 
		MosPUserDao dao = new MosPUserDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		vo.setFields(dao.findForCondition(vo.getTxtUserId(), vo.getTxtUserName(), vo.getPltAuthority(), vo.getPltDelete()));
		// Ώۂꍇ̃bZ[Wݒ
		if (vo.getEscAryUserId().length == 0) {
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
		}
	}

	/**
	 * pX[h
	 * @param vo     UserListVoCX^X
	 * @param userId Ώۃ[U[ID
	 * @throws Exception
	 */
	private void initPassword(AccountMasterListVo vo, String userId) throws Exception {
		// 
		MosPUserDao dao = new MosPUserDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		// f[^̏
		CmUserDto dto = dao.findForUpdate(userId);
		// ݊mF
		chkExist(dto);
		// l̐ݒ
		dto.setPassword(MospUtility.getDigest(MospUtility.getDigest(userId)));
		// f[^̍XV
		dao.update(dto, false);
		// R~bg
		commit();
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, CommonConst.MSG_INITIALIZE_PASSOWRD, getKName(dto.getKCode())));
		// OɃpX[hbZ[WcB
		LogUtility.log(request, 4, MospConst.LOG_SECURE, MospUtility.getMessage(msg, CommonConst.MSG_INITIALIZE_PASSOWRD, userId));
	}

	/**
	 * [hݒ
	 * @param vo
	 * @throws Exception
	 */
	private void setMode(AccountMasterListVo vo) throws Exception{
		// DBRlNV̎擾
		if (conn == null) {
			getConnection();
		}
		// 
		MosPUserDao dao = new MosPUserDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		List<CmUserDto> listHuman = dao.findAllMosPUser();
		// HUMANmF
		boolean hasAuth = false;
		String[][] aryHuman = getConfArray(CommonConst.CONF_ID_HUMAN);
		for (Iterator iter = listHuman.iterator(); iter.hasNext();) {
			CmUserDto dto = (CmUserDto) iter.next();
			for (int i = 0; i < aryHuman.length; i++) {
				if (aryHuman[i][0].equals(dto.getAuthority())) {
					hasAuth = true;
					break;
				}
			}
		}
		if (hasAuth) {		
			vo.setMode(AccountMasterListVo.MODE_VIEW);
		} else {
			vo.setMode(AccountMasterListVo.MODE_INSERT);
		}		
	}

	/**
	 * \[g
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(String key, AccountMasterListVo vo) throws MospException {
		vo.sortList(key, getComparator(key, vo));
		vo.setFields(vo.getList());
	}

	/**
	 * \[g(VÕL[Ń\[g)
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(AccountMasterListVo vo) throws MospException {
		vo.sortList(getComparator(vo.getFormerKey(), vo));
		vo.setFields(vo.getList());
	}

	/**
	 * rNX擾
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private Comparator<Object> getComparator(String key, AccountMasterListVo vo) throws MospException {
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_USER_ID)) {
			comp = new CompUserId();
		} else if (key.equals(vo.KEY_USER_NAME)) {
			comp = new CompUserName();
		} else if (key.equals(vo.KEY_AUTHORITY)) {
			comp = new CompMospAuthority();
		} else if (key.equals(vo.KEY_DELETE)) {
			comp = new CompDeleteFlag();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}

	/**
	 * [U[IDɂrNX
	 */
	protected static class CompUserId implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = -4583472093732229895L;
		public int compare(Object obj1, Object obj2) {
			CmUserDto dto1 = (CmUserDto)obj1;
			CmUserDto dto2 = (CmUserDto)obj2;
			return dto1.getUserId().compareTo(dto2.getUserId());
		}
	}

	/**
	 * [U[ɂrNX
	 */
	protected static class CompUserName implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = -8592798017682994795L;
		public int compare(Object obj1, Object obj2) {
			CmUserDto dto1 = (CmUserDto)obj1;
			CmUserDto dto2 = (CmUserDto)obj2;
			return dto1.getUserName().compareTo(dto2.getUserName());
		}
	}

	/**
	 * MosPpɂrNX
	 */
	protected static class CompMospAuthority implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = -5352768820840940232L;
		public int compare(Object obj1, Object obj2) {
			CmUserDto dto1 = (CmUserDto)obj1;
			CmUserDto dto2 = (CmUserDto)obj2;
			return dto1.getAuthority().compareTo(dto2.getAuthority());
		}
	}

	/**
	 * 폜tOɂrNX
	 */
	protected static class CompDeleteFlag implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = -6928899434272685923L;
		public int compare(Object obj1, Object obj2) {
			CmUserDto dto1 = (CmUserDto)obj1;
			CmUserDto dto2 = (CmUserDto)obj2;
			return dto2.getDeleteFlag() - dto1.getDeleteFlag();
		}
	}

}
